//
//  Copyright 2012 Justin.tv. All rights reserved.
//

#import "UIColorAdditions.h"

@implementation UIColor (Standards)
+ (UIColor *) twitchTextTitleColor {
	return [UIColor colorWithRed:(51.f / 255.f) green:(51.f / 255.f) blue:(51.f / 255.f) alpha:1.f];
}

+ (UIColor *) twitchCellTextTitleColor {
	return [UIColor colorWithRed:(51.f / 255.f) green:(51.f / 255.f) blue:(51.f / 255.f) alpha:1.f];
}

+ (UIColor *) twitchWhiteOverlayTextColor {
	
	return [UIColor colorWithWhite:1.f alpha:1.f];
}

+ (UIColor *) twitchPurpleOverlayTextColor {
	
	return [UIColor colorWithRed:(185.f / 255.f) green:(163.f / 255.f) blue:(227.f / 255.f) alpha:1.f];
}

+ (UIColor *) twitchGridItemBroadcastTitleColor {
	
	// #F9F4F8
	return [UIColor colorWithRed:(249.f / 255.f) green:(244.f / 255.f) blue:(248.f / 255.f) alpha:1.f];
}

+ (UIColor *) twitchCellBroadcastTitleTextColor {
	
	// #1E052E
	return [UIColor colorWithRed:(30.f / 255.f) green:(5.f / 255.f) blue:(46.f / 255.f) alpha:1.f];
}

+ (UIColor *) twitchCellTextColor
{
	return [UIColor colorWithWhite:0.f alpha:1.f];
}

+ (UIColor *) twitchCellBackgroundColorNormal
{
	return [UIColor colorWithWhite:1.f alpha:1.f];
}

+ (UIColor *) twitchCellBackgroundColorPressed
{
	return [UIColor colorWithWhite:235.f/255.f alpha:1.f];
}

+ (UIColor *) twitchCellDetailTextColor
{
	return [self twitchPurpleColor];
}

+ (UIColor *) twitchCellAccessoryColor
{
	return [UIColor colorWithRed:(204.f / 255.f) green:(204.f / 255.f) blue:(204.f / 255.f) alpha:1.f];
}

+ (UIColor *) twitchCellSeparatorColor
{
	return [UIColor colorWithRed:(235.f / 255.f) green:(235.f / 255.f) blue:(235.f / 255.f) alpha:1.f];
}

+ (UIColor *) twitchHeaderBackgroundColor
{
	return [UIColor colorWithWhite:239.f/255.f alpha:1.f];
}

+ (UIColor *) twitchHeaderTextColor
{
	return [self twitchPurpleColor];
}

+ (UIColor *) twitchHeaderSeparatorColor
{
	return [self twitchCellBackgroundColorNormal];
}

+ (UIColor *) twitchOptionsCellBackgroundColorPadNormal {
	
	// #FFFFFF
	return [UIColor whiteColor];
}

+ (UIColor *) twitchOptionsCellBackgroundColorPadPressed {
	
	// #614199
	return [self twitchNavigationMenuCellBackgroundColorPressed];
}

+ (UIColor *) twitchOptionsCellTextColor {
	
	// #d9d9e9
	return [self twitchNavigationMenuCellTextColorNormal];
}

+ (UIColor *) twitchOptionsSeparatorColorPhone {
	
	// #121216
	return [UIColor colorWithRed:(18.f / 255.f) green:(18.f / 255.f) blue:(22.f / 255.f) alpha:1.f];
}

+ (UIColor *) twitchOptionsSeparatorColorPad {
	
	// #EBEBEB
	return [UIColor colorWithWhite:235.f/255.f alpha:1.f];
}

+ (UIColor *) twitchOptionsAccessoryTintColor {
	
	return [self twitchLightPurpleColor];
}

+ (UIColor *) twitchOptionsMenuBackgroundColorPhone {
	
	// #141217
	return [UIColor colorWithRed:(20.f / 255.f) green:(18.f / 255.f) blue:(23.f / 255.f) alpha:1.f];
}

+ (UIColor *) twitchOptionsMenuBackgroundColorPad
{
	// #FAFAFA
	return [UIColor colorWithWhite:250.f/255.f alpha:1.f];
}

+ (UIColor *) twitchOptionsNavigationBarColorPhone {
	
	// #211f27
	return [self twitchNavigationMenuBackgroundColor];
}

+ (UIColor *) twitchOptionsNavigationBarColorPad {
	
	// #F9F9F9
	return [UIColor colorWithWhite:249.f/255.f alpha:1.f];
}

+ (UIColor *) twitchChatBackgroundColor {
	return [UIColor colorWithWhite:1.f alpha:1.f];
}

+ (UIColor *) twitchChatInputBorderColor {
	return [UIColor colorWithRed:(152.f / 255.f) green:(152.f / 255.f) blue:(152.f / 255.f) alpha:1.f];
}

+ (UIColor *) twitchChatInputBackgroundColorNormal {
	return [UIColor colorWithWhite:1.f alpha:1.f];
}

+ (UIColor *) twitchChatInputBackgroundColorActive {
	return [UIColor colorWithWhite:249.f/255.f alpha:1.f];
}

+ (UIColor *) twitchChatInputPlaceholderTextColor {
	return [UIColor colorWithRed:(185.f / 255.f) green:(163.f / 255.f) blue:(227.f / 255.f) alpha:1.f];
}

+ (UIColor *) twitchChatInputTextColor {
	return [UIColor colorWithWhite:0.f alpha:1.f];
}

+ (UIColor *) twitchPurpleButtonLabelColor {
	
	return [UIColor colorWithRed:185.f/255.f green:163.f/255.f blue:227.f/255.f alpha:1.f];
}

+ (UIColor *) twitchPurpleColor {
	
	// #6441A5
	return [UIColor colorWithRed:100.f/255.f green:65.f/255.f blue:165.f/255.f alpha:1.f];
}

+ (UIColor *) twitchLightPurpleColor {
	
	// #B9A3E3
	return [UIColor colorWithRed:185.f/255.f green:163.f/255.f blue:227.f/255.f alpha:1.f];
}

+ (UIColor *) twitchEmoteButtonColorDisabled
{
	return [UIColor colorWithWhite:225.f/255.f alpha:1.f];
}

+ (UIColor *) twitchEmoteButtonColorEnabled
{
	return [UIColor colorWithWhite:152.f/255.f alpha:1.f];
}

+ (UIColor *) twitchEmoteButtonColorPressed
{
	return [UIColor twitchPurpleColor];
}

+ (UIColor *) twitchNavigationMenuBackgroundColor {
	
	// #211f27
	return [UIColor colorWithRed:33.f/255.f green:31.f/255.f blue:39.f/255.f alpha:1.f];
}

+ (UIColor *) twitchNavigationMenuCellBackgroundColorNormal {
	
	// #19191f
	return [UIColor colorWithRed:25.f/255.f green:25.f/255.f blue:31.f/255.f alpha:1.f];
}

+ (UIColor *) twitchNavigationMenuCellBackgroundColorPressed {
	
	// #614199
	return [UIColor colorWithRed:97.f/255.f green:65.f/255.f blue:153.f/255.f alpha:1.f];
}

+ (UIColor *) twitchNavigationMenuCellBackgroundColorSelected
{
	// #000000
	return [UIColor colorWithWhite:0.f alpha:1.f];
}

+ (UIColor *) twitchNavigationMenuBroadcastIconColorNormal
{
	// #959595
	return [UIColor colorWithWhite:149.f/255.f alpha:1.f];
}

+ (UIColor *) twitchNavigationMenuBroadcastIconColorPressed
{
	return [UIColor twitchLightPurpleColor];
}

+ (UIColor *) twitchNavigationMenuBroadcastIconColorSelected
{
	// #796A95
	return [UIColor colorWithRed:121.f/255.f green:106.f/255.f blue:149.f/255.f alpha:1.f];
}

+ (UIColor *) twitchNavigationMenuCellSeparatorColorNormal {
	
	// #211f27
	return [self twitchNavigationMenuBackgroundColor];
}

+ (UIColor *) twitchNavigationMenuCellTextColorNormal {
	
	// #d9d9e9
	return [UIColor colorWithRed:217.f/255.f green:217.f/255.f blue:233.f/255.f alpha:1.f];
}

+ (UIColor *) twitchNavigationMenuCellTextColorPressed {
	
	// #ffffff
	return [UIColor colorWithWhite:1.f alpha:1.f];
}

+ (UIColor *) twitchNavigationMenuCellTextColorSelected
{
	// #ccb1ff
	return [UIColor colorWithRed:204.f/255.f green:177.f/255.f blue:255.f/255.f alpha:1.f];
}

+ (UIColor *) twitchNavigationMenuCellDetailTextColorNormal {
	
	// #959595
	return [UIColor colorWithWhite:149.f/255.f alpha:1.f];
}

+ (UIColor *) twitchNavigationMenuCellDetailTextColorPressed {
	
	// #b9a3e3
	return [self twitchLightPurpleColor];
}

+ (UIColor *) twitchNavigationMenuCellDetailTextColorSelected {
	
	// #796a95
	return [UIColor colorWithRed:121.f/255.f green:106.f/255.f blue:149.f/255.f alpha:1.f];
}

+ (UIColor *) twitchNavigationMenuHeaderBackgroundColor {
	
	return [UIColor twitchNavigationMenuBackgroundColor];
}

+ (UIColor *) twitchNavigationMenuHeaderSeparatorColor {
	
	return [UIColor twitchNavigationMenuCellBackgroundColorNormal];
}

+ (UIColor *) twitchNavigationMenuHeaderTextColor {
	
	return [UIColor colorWithWhite:1.f alpha:1.f];
}

+ (UIColor *) twitchNavigationMenuIconColorNormal {
	
	return [self twitchNavigationMenuCellTextColorNormal];
}

+ (UIColor *) twitchNavigationMenuIconColorPressed {
	
	return [self twitchNavigationMenuCellTextColorPressed];
}

+ (UIColor *) twitchNavigationMenuIconColorSelected
{
	// #CCB1FF
	return [self twitchNavigationMenuCellTextColorSelected];
}

+ (UIColor *) twitchNavigationMenuDisclosureIndicatorColorNormal {
	
	// #2E293C
	return [UIColor colorWithRed:46.f/255.f green:41.f/255.f blue:60.f/255.f alpha:1.f];
}

+ (UIColor *) twitchNavigationMenuDisclosureIndicatorColorPressed {
	
	// #19191F
	return [UIColor colorWithRed:25.f/255.f green:25.f/255.f blue:31.f/255.f alpha:1.f];
}

+ (UIColor *) twitchNavigationMenuDisclosureIndicatorColorSelected {
	
	// #2E293C
	return [self twitchNavigationMenuDisclosureIndicatorColorNormal];
}

+ (UIColor *) twitchNavigationMenuButtonBackgroundColorNormal
{
	return [UIColor colorWithRed:33.f/255.f green:31.f/255.f blue:39.f/255.f alpha:.92f];
}

+ (UIColor *) twitchNavigationMenuButtonBackgroundColorPressed
{
	return [UIColor colorWithRed:91.f/255.f green:60.f/255.f blue:150.f/255.f alpha:.92f];
}

+ (UIColor *) twitchNavigationMenuButtonTextColorNormal
{
	return [UIColor colorWithRed:185.f/255.f green:163.f/255.f blue:227.f/255.f alpha:1.f];
}

+ (UIColor *) twitchNavigationMenuButtonTextColorPressed
{
	return [UIColor colorWithWhite:0.f alpha:1.f];
}

+ (UIColor *) twitchBarIconColorNormal {
	
	return [UIColor colorWithWhite:1.f alpha:1.f];
}

+ (UIColor *) twitchBarIconColorPressed {
	
	return [UIColor colorWithRed:185.f/255.f green:163.f/255.f blue:227.f/255.f alpha:1.f];
}

+ (UIColor *) twitchOverlayIconColorNormal {
	
	return [UIColor colorWithWhite:1.f alpha:1.f];
}

+ (UIColor *) twitchOverlayIconColorPressed {
	
	return [UIColor colorWithRed:172.f/255.f green:172.f/255.f blue:172.f/255.f alpha:1.f];
}

+ (UIColor *) twitchOverlayIconColorActive {
	
	return [UIColor colorWithRed:199.f/255.f green:177.f/255.f blue:242.f/255.f alpha:1.f];
}

+ (UIColor *) twitchEmoticonIconColorDisabled {
	
	return [UIColor colorWithRed:225.f/255.f green:225.f/255.f blue:225.f/255.f alpha:1.f];
}

+ (UIColor *) twitchEmoticonIconColorNormal {
	
	return [UIColor colorWithRed:152.f/255.f green:152.f/255.f blue:152.f/255.f alpha:1.f];
}

+ (UIColor *) twitchEmoticonIconColorPressed {
	
	return [UIColor twitchPurpleColor];
}

+ (UIColor *) twitchSearchBarBackgroundColorNormal
{
	return [UIColor colorWithRed:25.f/255.f green:25.f/255.f blue:31.f/255.f alpha:1.f];
}

+ (UIColor *) twitchSearchBarBackgroundColorActive
{
	return [UIColor colorWithRed:47.f/255.f green:41.f/255.f blue:65.f/255.f alpha:1.f];
}

+ (UIColor *) twitchSearchBarTextColorNormal
{
	return [UIColor colorWithRed:217.f/255.f green:224.f/255.f blue:233.f/255.f alpha:1.f];
}

+ (UIColor *) twitchSearchBarTextColorActive
{
	return [UIColor colorWithWhite:1.f alpha:1.f];
}

+ (UIColor *) twitchSearchBarGlyphColorNormal
{
	return [self twitchSearchBarTextColorNormal];
}

+ (UIColor *) twitchSearchBarGlyphColorActive
{
	return [self twitchSearchBarTextColorActive];
}

+ (UIColor *) twitchAdProgressTrackColor
{
	return [UIColor colorWithWhite:0.f alpha:1.f];
}

+ (UIColor *) twitchAdProgressBarColor
{
	return [UIColor colorWithRed:255.f/255.f green:216.f/255.f blue:0.f/255.f alpha:1.f];
}

+ (UIColor *) twitchAdOverlayTextColor
{
	return [UIColor colorWithWhite:1.f alpha:1.f];
}

+ (UIColor *) twitchAdOverlayButtonTextColorPressed
{
	return [UIColor colorWithRed:172.f/255.f green:172.f/255.f blue:172.f/255.f alpha:1.f];
}

+ (UIColor *) twitchAdOverlayTextStrokeColor
{
	return [UIColor colorWithWhite:0.f alpha:.65f];
}

+ (UIColor *) twitchChatMemberListCellTextColor
{
	return [UIColor colorWithWhite:0.f alpha:1.f];
}

+ (UIColor *) twitchChatModerationButtonTitleColor
{
	return [UIColor colorWithWhite:1.f alpha:1.f];
}

+ (UIColor *) twitchChatModerationButtonUnmodTitleColor
{
	// #01BC1A
	return [UIColor colorWithRed:1.f/255.f green:188.f/255.f blue:26.f/255.f alpha:1.f];
}

+ (UIColor *) twitchChatModerationButtonTimedOutTitleColor
{
	// #EE9200
	return [UIColor colorWithRed:238.f/255.f green:146.f/255.f blue:0.f/255.f alpha:1.f];
}

+ (UIColor *) twitchChatModerationButtonModBackgroundColorNormal
{
	// #008D13
	return [UIColor colorWithRed:0.f/255.f green:141.f/255.f blue:19.f/255.f alpha:1.f];
}

+ (UIColor *) twitchChatModerationButtonModBackgroundColorPressed
{
	// #007310
	return [UIColor colorWithRed:0.f/255.f green:115.f/255.f blue:16.f/255.f alpha:1.f];
}

+ (UIColor *) twitchChatModerationButtonUnmodBackgroundColorNormal
{
	return [UIColor colorWithWhite:0.f alpha:1.f];
}

+ (UIColor *) twitchChatModerationButtonUnmodBackgroundColorPressed
{
	// #3D3D3D
	return [UIColor colorWithRed:61.f/255.f green:61.f/255.f blue:61.f/255.f alpha:1.f];
}

+ (UIColor *) twitchChatModerationButtonTimeOutBackgroundColorNormal
{
	// #FFA800
	return [UIColor colorWithRed:255.f/255.f green:168.f/255.f blue:0.f/255.f alpha:1.f];
}

+ (UIColor *) twitchChatModerationButtonTimeOutBackgroundColorPressed
{
	// #EE9200
	return [UIColor colorWithRed:238.f/255.f green:146.f/255.f blue:0.f/255.f alpha:1.f];
}

+ (UIColor *) twitchChatModerationButtonTimedOutBackgroundColor
{
	// #EBEBEB
	return [UIColor colorWithWhite:235.f/255.f alpha:1.f];
}

+ (UIColor *) twitchChatModerationButtonBanBackgroundColorNormal
{
	// #DE0000
	return [UIColor colorWithRed:222.f/255.f green:0.f/255.f blue:0.f/255.f alpha:1.f];
}

+ (UIColor *) twitchChatModerationButtonBanBackgroundColorPressed
{
	// #C10101
	return [UIColor colorWithRed:193.f/255.f green:1.f/255.f blue:1.f/255.f alpha:1.f];
}

+ (UIColor *) twitchProfileHeaderColorCollapsed
{
	// #F9F9F9
	return [UIColor colorWithWhite:249.f/255.f alpha:1.f];
}

+ (UIColor *) twitchProfileSeparatorColor
{
	// #C4C4C4
	return [UIColor colorWithWhite:196.f/255.f alpha:1.f];
}

+ (UIColor *) twitchGameBoxArtTextOverlayColor
{
	// #B9A3E3
	return [UIColor colorWithRed:185.f/255.f green:163.f/255.f blue:227.f/255.f alpha:1.f];
}

+ (UIColor *) twitchWelcomeTextColor
{
	// #B9A3E3
	return [UIColor colorWithRed:185.f/255.f green:163.f/255.f blue:227.f/255.f alpha:1.f];
}

+ (UIColor *) twitchWelcomeBottomLoginButtonColor
{
	// return [UIColor colorWithWhite:239.f/255.f alpha:.92f];
	return [UIColor colorWithWhite:249.f/255.f alpha:.95f];
}

+ (UIColor *) twitchSharingButtonColorNormal
{
	return [UIColor twitchPurpleColor];
}

+ (UIColor *) twitchSharingButtonColorPressed
{
	// #503484
	return [UIColor colorWithRed:80.f/255.f green:52.f/255.f blue:132.f/255.f alpha:1.f];
}

+ (UIColor *) facebookSharingButtonColorNormal
{
	// #2C5D94
	return [UIColor colorWithRed:44.f/255.f green:93.f/255.f blue:148.f/255.f alpha:1.f];
}

+ (UIColor *) facebookSharingButtonColorPressed
{
	// #2f477a
	return [UIColor colorWithRed:47.f/255.f green:71.f/255.f blue:122.f/255.f alpha:1.f];
}

+ (UIColor *) twitterSharingButtonColorNormal
{
	// #00aced
	return [UIColor colorWithRed:0.f/255.f green:172.f/255.f blue:237.f/255.f alpha:1.f];
}

+ (UIColor *) twitterSharingButtonColorPressed
{
	// #008abe
	return [UIColor colorWithRed:0.f/255.f green:138.f/255.f blue:190.f/255.f alpha:1.f];
}

+ (UIColor *) twitchSegmentedControlTextColorNormal
{
	// #583992
	return [UIColor colorWithRed:88.f/255.f green:57.f/255.f blue:146.f/255.f alpha:1.f];
}

+ (UIColor *) twitchSegmentedControlTextColorSelected
{
	// #FFFFFF
	return [UIColor whiteColor];
}

+ (UIColor *) twitchRatingPromptBannerBackgroundColor
{
	return [UIColor colorWithWhite:0.f alpha:.92f];
}

+ (UIColor *) twitchRatingPromptAccessoryColor
{
	// #434343
	return [UIColor colorWithWhite:67.f/255.f alpha:1.f];
}

+ (UIColor *) twitchSearchBarCancelButtonColorNormal
{
	return [UIColor twitchPurpleColor];
}

+ (UIColor *) twitchSearchBarCancelButtonColorPressed
{
	// #B9A3E3
	return [UIColor colorWithRed:185.f/255.f green:163.f/255.f blue:227.f/255.f alpha:1.f];
}

+ (UIColor *) twitchSearchBarHeaderBackgroundColor
{
	// #F9F9F9
	return [UIColor colorWithWhite:249.f/255.f alpha:1.f];
}

+ (UIColor *) twitchMoreResultsItemBackgroundColorNormal
{
	// #EFEFEF
	return [UIColor colorWithWhite:239.f/255.f alpha:1.f];
}

+ (UIColor *) twitchMoreResultsItemBackgroundColorPressed
{
	return [UIColor twitchLightPurpleColor];
}

+ (UIColor *) twitchNoContentCellIconColor
{
	return [self twitchLightPurpleColor];
}

+ (UIColor *) twitchNoContentCellTextColor
{
	// #ADADAD
	return [UIColor colorWithWhite:173.f/255.f alpha:1.f];
}

+ (UIColor *) twitchNoContentCellDetailTextColor
{
	return [self twitchLightPurpleColor];
}

@end
